//%attributes = {}
// Method: pr_nc_ NEED_GET
// 2002.11.19-14:17:39 / Pasi Mankinen
// © Copyright 2002 Manage Applications
// Purpose: 
// 
// ------------------------------------------------------------
// calculates total need of products in arrays using previously built tree arrays
// tree_ UP_BUILD or tree_ DOWN_BUILD _must_ have been called before calling
// this method
// ------------------------------------------------------------
//ak 2003-10-10
//
//*** this method resizes $pr_nc_pProductArr -array! ***
//
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_POINTER:C301($1; $pr_nc_pProductArr; $2; $pr_nc_pAmountArr)
C_TEXT:C284($3; $pr_nc_tParameters)  //query names for coming, going
C_LONGINT:C283($4; $pr_nc_lSaldoArrCalculate; $pr_nc_lSaldoUse)
C_TEXT:C284($pr_nc_tActionLimitUse; $pr_nc_tSaldoUse; $pr_nc_tComingQuery_por; $pr_nc_tGoingQuery_sor; $pr_nc_tComingQuery_wo; $pr_nc_tGoingQuery_wo)
C_LONGINT:C283($pr_nc_lAmountFind; $pr_nc_lAmountArrSize; $pr_nc_lAmountIndex; $pr_nc_lTreeArrSize; $pr_nc_lTreeIndex; $pr_nc_lInsertIndex)
C_LONGINT:C283($pr_nc_lActionLimitUse; $pr_nc_lArrSizeAdd; $pr_nc_lAmountArrTrueSize; $pr_nc_lSaldoIndex; $pr_nc_lSaldoCalculate)
C_TEXT:C284($pr_nc_tProduct)
C_REAL:C285($pr_nc_rAmount)

$pr_nc_pProductArr:=$1
$pr_nc_pAmountArr:=$2
$pr_nc_tParameters:=$3  // "use saldo;por_in;sor_out;wo_in;wo_out;use stock limit" 
If (Count parameters:C259>=4)
	$pr_nc_lSaldoArrCalculate:=$4
Else 
	$pr_nc_lSaldoArrCalculate:=kTrue  //$4 (count parameters) don't reload from db
End if 

$pr_nc_tSaldoUse:=_str Parse($pr_nc_tParameters; ";"; 1)

Case of 
	: ($pr_nc_tSaldoUse="=")  //use default 2003-07-29
		$pr_nc_lSaldoUse:=<>pr_nc_lSaldoInUse
	: ($pr_nc_tSaldoUse="")
		$pr_nc_lSaldoUse:=0
	Else 
		$pr_nc_lSaldoUse:=Num:C11($pr_nc_tSaldoUse)  //pr_nc_atSaldoProductArr, pr_nc_arSaldoArr
End case 
$pr_nc_tComingQuery_por:=_str Parse($pr_nc_tParameters; ";"; 2)
$pr_nc_tGoingQuery_sor:=_str Parse($pr_nc_tParameters; ";"; 3)
$pr_nc_tComingQuery_wo:=_str Parse($pr_nc_tParameters; ";"; 4)
$pr_nc_tGoingQuery_wo:=_str Parse($pr_nc_tParameters; ";"; 5)
$pr_nc_tActionLimitUse:=_str Parse($pr_nc_tParameters; ";"; 6)
Case of   //ak 2003-10-10
	: ($pr_nc_tActionLimitUse="=")  //use default 
		$pr_nc_lActionLimitUse:=<>pr_nc_lActionLimitInUse
	: ($pr_nc_tActionLimitUse="")
		$pr_nc_lActionLimitUse:=0
	Else 
		$pr_nc_lActionLimitUse:=Num:C11($pr_nc_tActionLimitUse)  //pr_nc_atSaldoProductArr, pr_nc_arSaldoArr
End case 

$pr_nc_lSaldoCalculate:=Num:C11(($pr_nc_lActionLimitUse=1) | ($pr_nc_lSaldoUse=1) | ($pr_nc_tComingQuery_por#"") | ($pr_nc_tGoingQuery_sor#"") | ($pr_nc_tComingQuery_wo#"") | ($pr_nc_tGoingQuery_wo#""))

Case of 
	: ((Type:C295($pr_nc_pProductArr->)#Text array:K8:16) & (Type:C295($pr_nc_pProductArr->)#String array:K8:15))
		_err MESSAGE_PARAMETER("Need array type is not text array"; Current method name:C684; kFalse)
	: (Type:C295($pr_nc_pAmountArr->)#Real array:K8:17)
		_err MESSAGE_PARAMETER("Need array type is not real array"; Current method name:C684; kFalse)
	: (Size of array:C274($pr_nc_pProductArr->)#Size of array:C274($pr_nc_pAmountArr->))
		_err MESSAGE_PARAMETER("Arrays are not equally sized"; Current method name:C684; kFalse)
	Else 
		//real code starts
		$pr_nc_lArrSizeAdd:=100
		ARRAY REAL:C219(pr_nc_arNeedRunningSaldo; 0)
		//ARRAY REAL(pr_nc_arNeedRunningSaldoAfter;0)
		
		ARRAY TEXT:C222(pr_nc_atWork_id; 0)
		ARRAY TEXT:C222(pr_nc_atWorkProduct_id; 0)
		ARRAY TEXT:C222(pr_nc_atPartProduct_id; 0)
		ARRAY REAL:C219(pr_nc_arPartMultiplier; 0)
		tree_ BUILD_ARR_GET(->pr_nc_atWork_id; ->pr_nc_atWorkProduct_id; ->pr_nc_atPartProduct_id; ->pr_nc_arPartMultiplier)
		
		ARRAY TEXT:C222(pr_nc_atCombinedProduct_id; 0)
		tree_ COMBINED_PRODUCT_ARR_GET(->pr_nc_atCombinedProduct_id; kFalse)
		
		If ($pr_nc_lSaldoCalculate=kTrue)
			
			If ($pr_nc_lSaldoArrCalculate=kTrue)
				pr_nc_SALDO_ARR_FILL(->pr_nc_atCombinedProduct_id; $pr_nc_tParameters)  //does actual queries from database
			End if 
			
			//PM 2003-10-09
			ARRAY REAL:C219(pr_nc_arSaldoArr; Size of array:C274(pr_nc_arSaldoArrOrig))  //PM 2003-10-09
			ARRAY REAL:C219(pr_nc_arActionLimitArr; Size of array:C274(pr_nc_arActionLimitArrOrig))
			If ($pr_nc_lSaldoUse=0)  //ak 2002-12-02
				_arr CLEAR(1; ->pr_nc_arSaldoArr)
			Else 
				COPY ARRAY:C226(pr_nc_arSaldoArrOrig; pr_nc_arSaldoArr)
			End if 
			If ($pr_nc_lActionLimitUse=0)
				_arr CLEAR(1; ->pr_nc_arActionLimitArr)
			Else 
				COPY ARRAY:C226(pr_nc_arActionLimitArrOrig; pr_nc_arActionLimitArr)
			End if 
			For ($pr_nc_lIndex; 1; Size of array:C274(pr_nc_arSaldoArr))
				pr_nc_arSaldoArr{$pr_nc_lIndex}:=pr_nc_arSaldoArr{$pr_nc_lIndex}-pr_nc_arActionLimitArr{$pr_nc_lIndex}
			End for 
			//end PM 2003-10-09      
			
			If (Size of array:C274(pr_nc_atNeedProduct)<1)
				//TRACE  `what to do?
			End if 
			_arr COPY(->pr_nc_atNeedProduct; $pr_nc_pProductArr; kMaxTextLen)
			_arr COPY(->pr_nc_arNeedAmount; $pr_nc_pAmountArr; kMaxTextLen)
		End if 
		
		$pr_nc_lAmountArrSize:=Size of array:C274($pr_nc_pProductArr->)
		$pr_nc_lAmountArrTrueSize:=$pr_nc_lAmountArrSize
		ARRAY LONGINT:C221(pr_nc_alNeedArrRowNum; $pr_nc_lAmountArrSize)
		ARRAY LONGINT:C221(pr_nc_alNeedArrRowNumPrev; $pr_nc_lAmountArrSize)
		_arr INDEX_CREATE(->pr_nc_alNeedArrRowNum; 1)
		COPY ARRAY:C226(pr_nc_alNeedArrRowNum; pr_nc_alNeedArrRowNumPrev)
		_arr RESIZE(->pr_nc_arNeedRunningSaldo; $pr_nc_lAmountArrSize)
		// _arr RESIZE (->pr_nc_arNeedRunningSaldoAfter;$pr_nc_lAmountArrSize)
		
		
		//this code is needed to correct amounts of added 
		//rows coming from upper level calculations
		ARRAY TEXT:C222(pr_nc_atStockUnitTmp; 0)
		C_LONGINT:C283($pr_nc_lTempArrSize)
		$pr_nc_lTempArrSize:=Size of array:C274(pr_nc_atCombinedProduct_id)
		ARRAY REAL:C219(pr_nc_arStock1Quantity; $pr_nc_lTempArrSize)
		For ($pr_nc_lInsertIndex; 1; $pr_nc_lTempArrSize)
			pr_nc_arStock1Quantity{$pr_nc_lInsertIndex}:=1
		End for 
		pr_ DESIGN1_AMOUNT_TO_STOCK1(->pr_nc_atCombinedProduct_id; ->pr_nc_arStock1Quantity; ->pr_nc_arStock1Quantity; ->pr_nc_atStockUnitTmp)
		//end of correction code
		
		$pr_nc_lTreeArrSize:=Size of array:C274(pr_nc_atWorkProduct_id)
		$pr_nc_lInsertIndex:=$pr_nc_lAmountArrSize+1
		$pr_nc_lAmountIndex:=1
		While ($pr_nc_lAmountIndex<=$pr_nc_lAmountArrSize)
			$pr_nc_tProduct:=$pr_nc_pProductArr->{$pr_nc_lAmountIndex}
			
			$pr_nc_rAmount:=$pr_nc_pAmountArr->{$pr_nc_lAmountIndex}
			If ($pr_nc_lSaldoCalculate=kTrue)
				$pr_nc_lSaldoIndex:=Find in array:C230(pr_nc_atSaldoProductArr; $pr_nc_tProduct)
				Case of 
					: ($pr_nc_lSaldoIndex<1)  //not found!
						_err MESSAGE(_lang Current("Product stock balance not found"); Current method name:C684; kFalse)
					Else 
						If ($pr_nc_lSaldoUse=1)
							pr_nc_arNeedRunningSaldo{$pr_nc_lAmountIndex}:=pr_nc_arSaldoArr{$pr_nc_lSaldoIndex}
							Case of 
								: (pr_nc_arSaldoArr{$pr_nc_lSaldoIndex}>=(-$pr_nc_rAmount))  //saldo bigger than amount
									pr_nc_arSaldoArr{$pr_nc_lSaldoIndex}:=pr_nc_arSaldoArr{$pr_nc_lSaldoIndex}+$pr_nc_rAmount
									$pr_nc_rAmount:=0  //saldo is enough, don't create sub-structure
								Else 
									$pr_nc_rAmount:=$pr_nc_rAmount+pr_nc_arSaldoArr{$pr_nc_lSaldoIndex}  //remove saldo from need
									//we used to have need going down here, not any more
									pr_nc_arSaldoArr{$pr_nc_lSaldoIndex}:=0  //saldo used now
							End case 
							//pr_nc_arNeedRunningSaldoAfter{$pr_nc_lAmountIndex}:=pr_nc_arSaldoArr{$pr_nc_lS
							//~aldoIndex}
						End if 
						
				End case 
			End if 
			
			
			If ($pr_nc_rAmount>=0)
				//no need so don't create sub structure          
				$pr_nc_lTreeIndex:=0  //end tree array, go to next in need array
			Else 
				
				
				$pr_nc_lTreeIndex:=Find in array:C230(pr_nc_atWorkProduct_id; $pr_nc_tProduct)
				//if not found then product has no lower parts, so check only if found
				While ($pr_nc_lTreeIndex>0)
					//add elemet to need array end
					If ($pr_nc_lInsertIndex>$pr_nc_lAmountArrTrueSize)
						INSERT IN ARRAY:C227($pr_nc_pProductArr->; $pr_nc_lInsertIndex; $pr_nc_lArrSizeAdd)
						INSERT IN ARRAY:C227($pr_nc_pAmountArr->; $pr_nc_lInsertIndex; $pr_nc_lArrSizeAdd)
						INSERT IN ARRAY:C227(pr_nc_alNeedArrRowNum; $pr_nc_lInsertIndex; $pr_nc_lArrSizeAdd)
						INSERT IN ARRAY:C227(pr_nc_alNeedArrRowNumPrev; $pr_nc_lInsertIndex; $pr_nc_lArrSizeAdd)
						INSERT IN ARRAY:C227(pr_nc_arNeedRunningSaldo; $pr_nc_lInsertIndex; $pr_nc_lArrSizeAdd)
						// INSERT IN ARRAY(pr_nc_arNeedRunningSaldoAfter;$pr_nc_lInsertIndex;$pr_nc_lArrS
						//~izeAdd)
						
						$pr_nc_lAmountArrTrueSize:=Size of array:C274($pr_nc_pProductArr->)
					End if 
					$pr_nc_pProductArr->{$pr_nc_lInsertIndex}:=pr_nc_atPartProduct_id{$pr_nc_lTreeIndex}
					$pr_nc_pAmountArr->{$pr_nc_lInsertIndex}:=$pr_nc_rAmount*pr_nc_arPartMultiplier{$pr_nc_lTreeIndex}
					
					//this code is needed to correct amounts of added 
					//rows coming from upper level calculations
					$pr_nc_lProductIndexTmp:=Find in array:C230(pr_nc_atCombinedProduct_id; $pr_nc_pProductArr->{$pr_nc_lInsertIndex})
					If ($pr_nc_lProductIndexTmp>0)
						$pr_nc_pAmountArr->{$pr_nc_lInsertIndex}:=$pr_nc_pAmountArr->{$pr_nc_lInsertIndex}*pr_nc_arStock1Quantity{$pr_nc_lProductIndexTmp}
					Else 
						_err MESSAGE(_lang Current("Product not found from amount change array")+": "+$pr_nc_pProductArr->{$pr_nc_lInsertIndex}; Current method name:C684; kFalse)
					End if 
					//end of correction code        
					
					pr_nc_alNeedArrRowNumPrev{$pr_nc_lInsertIndex}:=$pr_nc_lAmountIndex  //copy causing row number
					pr_nc_alNeedArrRowNum{$pr_nc_lInsertIndex}:=pr_nc_alNeedArrRowNum{$pr_nc_lAmountIndex}  //copy original row number
					$pr_nc_lAmountArrSize:=$pr_nc_lInsertIndex
					$pr_nc_lInsertIndex:=$pr_nc_lInsertIndex+1
					//-end- add elemet to need array end
					
					//run to next in tree array
					If ($pr_nc_lTreeIndex>=$pr_nc_lTreeArrSize)
						$pr_nc_lTreeIndex:=0  //end of tree array
					Else 
						If (pr_nc_atWorkProduct_id{$pr_nc_lTreeIndex}=pr_nc_atWorkProduct_id{$pr_nc_lTreeIndex+1})
							$pr_nc_lTreeIndex:=$pr_nc_lTreeIndex+1
						Else 
							$pr_nc_lTreeIndex:=0  //no more same pr_nc_atWorkProduct_id, go next product
						End if 
					End if 
					//-end- run to next in tree array
				End while 
			End if   //was there need?
			$pr_nc_lAmountIndex:=$pr_nc_lAmountIndex+1
			
		End while 
		
		_arr RESIZE($pr_nc_pProductArr; $pr_nc_lAmountArrSize)
		_arr RESIZE($pr_nc_pAmountArr; $pr_nc_lAmountArrSize)
		_arr RESIZE(->pr_nc_alNeedArrRowNum; $pr_nc_lAmountArrSize)
		_arr RESIZE(->pr_nc_alNeedArrRowNumPrev; $pr_nc_lAmountArrSize)
		_arr RESIZE(->pr_nc_arNeedRunningSaldo; $pr_nc_lAmountArrSize)
		// _arr RESIZE (->pr_nc_arNeedRunningSaldoAfter;$pr_nc_lAmountArrSize)
		
		
End case 
//end

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 
